#ifndef _DOCONNECT_CPP
#define _DOCONNECT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <IOStream>

#include "SockServer.H"
#include "../Source/Routines.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SocketServer::DoConnect(char *sRemoteAddr, int iRemotePort, int *ioutClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> SocketServer::DoConnect.\n");
    #endif

	SOCKADDR_IN RemoteServerSocketAddress;

	SOCKET sckLocalSocket = 0;

    if(icCurrentClients == icMaxClients)
	{
		WriteSysLog("Connect failed. Too many clients.");
		return false;
	}

	RemoteServerSocketAddress.sin_family      = AF_INET;
	RemoteServerSocketAddress.sin_port        = htons(iRemotePort);
	RemoteServerSocketAddress.sin_addr.s_addr = inet_addr(sRemoteAddr);

	sckLocalSocket = socket(AF_INET, SOCK_STREAM, 0);

	if(connect(sckLocalSocket, (struct sockaddr *) &RemoteServerSocketAddress, sizeof(RemoteServerSocketAddress)) == SOCKET_ERROR)
	{
        WSASendDisconnect(sckLocalSocket, NULL);
		shutdown(sckLocalSocket, SD_BOTH);
		closesocket(sckLocalSocket);
		return false;
	}

	if((*ioutClient = SelectFreeSocket()) == -1)
	{
        WriteSysLog("Connect failed. Not enough resources.");
        WSASendDisconnect(sckLocalSocket, NULL);
		shutdown(sckLocalSocket, SD_BOTH);
		closesocket(sckLocalSocket);
		return false;
	}

    if(!OnAcceptConnectClient(*ioutClient))
    {
        WriteSysLog("SocketServer::DoConnect : Connect failed. OnAcceptConnectClient returned false.");
        WSASendDisconnect(sckLocalSocket, NULL);
		shutdown(sckLocalSocket, SD_BOTH);
		closesocket(sckLocalSocket);
    }

    icClientID[*ioutClient] = icNextClientID++;
    bcConnected[*ioutClient] = true;
    bcDisconnect[*ioutClient] = false;
    sckcSocket[*ioutClient] = sckLocalSocket;

    icCurrentClients++;

	WriteLog(icClientID[*ioutClient], "Connected.");

    return Start_ClientThread(*ioutClient);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
